package gov.va.med.mhv.usermgmt.persist.ldap;

import netscape.ldap.LDAPConnection;

import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

/**
 * Base class for functions against a directory server.
 *
 * @author Jon Crater Apr 4, 2006 3:25:15 PM
 */
public abstract class LdapFunction {
	// for now, just accept the default defined in GenericObjectPool
	private static ObjectPool pool = new GenericObjectPool(new LdapPoolableConnectionFactory());
	
	/** Exception translation strategy. */
	private LdapExceptionTranslator exceptionTranslator = new LdapExceptionTranslator();
	
	/**
	 * The connection to our directory server.
	 */
	protected LDAPConnection conn;
	
	/**
	 * The relevant environment configuration for our directory server.
	 */
	protected LdapEnvironment env;
	
	protected LdapFunction() {
		this.env = LdapEnvironment.getInstance();
		connect();
	}

	/**
	 * Connect to the configured directory.
	 */
	protected void connect() {		
		try {
			conn = (LDAPConnection)pool.borrowObject();
		}
		catch(Exception e) {
			throw new RuntimeException("Exception borrowing LDAP connection from pool", e);
		}
	}

	/**
	 * Disconnect from the configured directory.
	 */
	protected void disconnect() {
		try {
			pool.returnObject(conn);
		}
		catch(Exception e) {
			throw new RuntimeException("Exception returning LDAP connection to pool", e);
		}
	}
	
	public LdapExceptionTranslator getExceptionTranslator() {
		return exceptionTranslator;
	}
	
	public void setExceptionTranslator(LdapExceptionTranslator exceptionTranslator) {
		this.exceptionTranslator = exceptionTranslator;
	}
}